/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks.plants;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.types.Plant;
import net.dries007.tfc.objects.blocks.plants.BlockPlantTFC;
import net.dries007.tfc.util.climate.ClimateTFC;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;

@ParametersAreNonnullByDefault
public class BlockMushroomTFC
extends BlockPlantTFC
implements IGrowable {
    private static final Map<Plant, BlockMushroomTFC> MAP = new HashMap<Plant, BlockMushroomTFC>();

    public static BlockMushroomTFC get(Plant plant) {
        return MAP.get((Object)plant);
    }

    public BlockMushroomTFC(Plant plant) {
        super(plant);
        if (MAP.put(plant, this) != null) {
            throw new IllegalStateException("There can only be one.");
        }
    }

    @Override
    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) && this.func_180671_f(worldIn, pos, this.func_176223_P());
    }

    @Override
    protected boolean func_185514_i(IBlockState state) {
        return state.func_185913_b();
    }

    @Override
    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.func_175697_a(pos, 1)) {
            return;
        }
        if (this.plant.isValidGrowthTemp(ClimateTFC.getActualTemp(worldIn, pos)) && this.plant.isValidSunlight(Math.subtractExact(worldIn.func_175642_b(EnumSkyBlock.SKY, pos), worldIn.func_175657_ab()))) {
            int j = (Integer)state.func_177229_b((IProperty)AGE);
            if (rand.nextDouble() < this.getGrowthRate(worldIn, pos) && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos.func_177984_a(), (IBlockState)state, (boolean)true)) {
                if (j == 3 && this.func_176473_a(worldIn, pos, state, worldIn.field_72995_K)) {
                    this.func_176474_b(worldIn, rand, pos, state);
                } else if (j < 3) {
                    worldIn.func_175656_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(j + 1)));
                }
                ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state, (IBlockState)worldIn.func_180495_p(pos));
            }
        } else if (!this.plant.isValidGrowthTemp(ClimateTFC.getActualTemp(worldIn, pos)) || !this.plant.isValidSunlight(worldIn.func_175642_b(EnumSkyBlock.SKY, pos))) {
            int j = (Integer)state.func_177229_b((IProperty)AGE);
            if (rand.nextDouble() < this.getGrowthRate(worldIn, pos) && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (IBlockState)state, (boolean)true)) {
                if (j == 0 && this.canShrink(worldIn, pos)) {
                    this.shrink(worldIn, pos);
                } else if (j > 0) {
                    worldIn.func_175656_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(j - 1)));
                }
                ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state, (IBlockState)worldIn.func_180495_p(pos));
            }
        }
        this.func_176475_e(worldIn, pos, state);
    }

    @Override
    public boolean func_180671_f(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.func_189509_E(pos)) {
            IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());
            return this.plant.isValidSunlight(worldIn.func_175699_k(pos)) && soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
        }
        return false;
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        int i = 5;
        for (BlockPos blockpos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-4, -1, -4), (BlockPos)pos.func_177982_a(4, 1, 4))) {
            if (worldIn.func_180495_p(blockpos).func_177230_c() != this || --i > 0) continue;
            return false;
        }
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        BlockPos blockpos1 = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(2) - rand.nextInt(2), rand.nextInt(3) - 1);
        for (int k = 0; k < 4; ++k) {
            if (worldIn.func_175623_d(blockpos1) && this.func_180671_f(worldIn, blockpos1, this.func_176223_P())) {
                pos = blockpos1;
            }
            blockpos1 = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(2) - rand.nextInt(2), rand.nextInt(3) - 1);
        }
        if (worldIn.func_175623_d(blockpos1) && this.func_180671_f(worldIn, blockpos1, this.func_176223_P())) {
            worldIn.func_180501_a(blockpos1, this.func_176223_P(), 2);
        }
    }

    private boolean canShrink(World worldIn, BlockPos pos) {
        for (BlockPos blockpos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-4, -1, -4), (BlockPos)pos.func_177982_a(4, 1, 4))) {
            if (worldIn.func_180495_p(blockpos).func_177230_c() != this) continue;
            return true;
        }
        return false;
    }

    private void shrink(World worldIn, BlockPos pos) {
        worldIn.func_175698_g(pos);
    }
}

